﻿// Lösung 2.Aufgabe: Implementation von SortedList<T>
using System;
using System.Collections.Generic;
using System.Collections;
using System.Text;

namespace SortedList
{
    class SortedList<T> : System.Collections.IEnumerable
      where T : IComparable
    {
        elem<T> first;
        public void Add(T newval)
        {
            elem<T> newelem = new elem<T>(newval);
            // 1. Fall: leere Liste
            if (first == null)
                first = newelem;
            else
                // 2. Fall: erstes Listenelement
                if (first.value.CompareTo(newval) > 0) // neues Element wird erstes
                {
                    newelem.next = first;
                    first = newelem;
                }
                else
                {
                    // Platz für newelem suchen
                    elem<T> e = first;
                    while (e.next != null && e.next.value.CompareTo(newval) < 0)
                        e = e.next;
                    // 3. Fall: nach e einsortieren 
                    newelem.next = e.next;
                    e.next = newelem;
                }
        }

        public bool IsEmpty()
        {
            return first == null;
        }

        public bool Remove(T val)
        {
            // 1.Fall Liste leer
            if (first != null)
                // 2.Fall erstes Element entfernen
                if (first.value.CompareTo(val) == 0)
                {
                    first = first.next;
                    return true;
                }
                else
                {
                    elem<T> e = first;
                    while (e.next != null && e.next.value.CompareTo(val) != 0)
                        e = e.next;
                    // 3. Fall: mittleres Listenelement entfernen
                    if (e.next != null)
                    {
                        e.next = e.next.next;
                        return true;
                    }
                }
            return false;
        }

        class elem<V>
        {
            public V value;
            public elem<V> next = null;
            public elem(V val)
            {
                value = val;
            }
        }

        IEnumerator System.Collections.IEnumerable.GetEnumerator()
        {
            return GetEnumerator();
        }

        public IEnumerator<T> GetEnumerator()
        {
            elem<T> e = first;
            while (e != null)
            {
                yield return e.value;
                e = e.next;
            }
        }
    }
}
